% Quick DeltaF Optical Imaging Program

% setup analysis parameters
%firstframebaseline=input('Enter the first frame of the baseline period: ');
%lastframebaseline=input('Enter the last frame of the baseline period: ');

%firstframepeak=input('Enter the first frame of the peak period: ');
%lastframepeak=input('Enter the last frame of the peak period: ');

%fixed analysis parameters
firstframebaseline=1;
lastframebaseline=50;
firstframepeak=51;
lastframepeak=60;

% load blocks
numberOfBlocks=input('Enter the number of blocks: ');
blockFolder=uigetdir(pwd,'Select Folder with Blocks');
cd(blockFolder);
filesName=input('Enter the name base: ','s');
    % enter Gosha_FP_1_E7B for test data

for block = 1:numberOfBlocks
    fileName=sprintf(strcat(filesName,'%d.mat'),block);
q    load(fileName);
    disp(['Loaded ',fileName]);

    accumulatedc0(:,:,:,block)=c0;
    accumulatedc1(:,:,:,block)=c1;
    
%keep track of runs
%block=input('Which block is this? ');

%%%%%%%%%%%%%%%%%%%%%
%     0th second    %
%%%%%%%%%%%%%%%%%%%%%
% analyze blank run (c0)
beforeframes=c0(:,:,firstframebaseline:lastframebaseline);
[vertpixels horizpixels numbeforeframes]=size(beforeframes);
sumbefore=sum(beforeframes,3);
avebefore=sumbefore/numbeforeframes;
peakframes=c0(:,:,firstframepeak-20:lastframepeak-10);
[vertpixels horizpixels numpeakframes]=size(peakframes);
sumpeak=sum(peakframes,3);
avepeak=sumpeak/numpeakframes;
deltafc0=avepeak-avebefore;
deltafoverfc0=deltafc0./avebefore;

% analyze active run (c1)
beforeframes=c1(:,:,firstframebaseline:lastframebaseline);
sumbefore=sum(beforeframes,3);
avebefore=sumbefore/numbeforeframes;
peakframes=c1(:,:,firstframepeak-20:lastframepeak-10);
sumpeak=sum(peakframes,3);
avepeak=sumpeak/numpeakframes;
deltafc1=avepeak-avebefore;
deltafoverfc1=deltafc1./avebefore;

% take difference of active and blank run
diffdeltafoverf=deltafoverfc1-deltafoverfc0;

% combine the different blocks and show average image
map0(:,:,block)=diffdeltafoverf;
meanmap0=mean(map0,3);

%%%%%%%%%%%%%%%%%%%%%
%     1st second    %
%%%%%%%%%%%%%%%%%%%%%
% analyze blank run (c0)
beforeframes=c0(:,:,firstframebaseline:lastframebaseline);
[vertpixels horizpixels numbeforeframes]=size(beforeframes);
sumbefore=sum(beforeframes,3);
avebefore=sumbefore/numbeforeframes;
peakframes=c0(:,:,firstframepeak:lastframepeak);
[vertpixels horizpixels numpeakframes]=size(peakframes);
sumpeak=sum(peakframes,3);
avepeak=sumpeak/numpeakframes;
deltafc0=avepeak-avebefore;
deltafoverfc0=deltafc0./avebefore;

% analyze active run (c1)
beforeframes=c1(:,:,firstframebaseline:lastframebaseline);
sumbefore=sum(beforeframes,3);
avebefore=sumbefore/numbeforeframes;
peakframes=c1(:,:,firstframepeak:lastframepeak);
sumpeak=sum(peakframes,3);
avepeak=sumpeak/numpeakframes;
deltafc1=avepeak-avebefore;
deltafoverfc1=deltafc1./avebefore;

% take difference of active and blank run
diffdeltafoverf=deltafoverfc1-deltafoverfc0;

% combine the different blocks and show average image
map1(:,:,block)=diffdeltafoverf;
meanmap1=mean(map1,3);
%imagesc(meanmap);

%%%%%%%%%%%%%%%%%%%%%
%     2nd second    %
%%%%%%%%%%%%%%%%%%%%%
% analyze blank run (c0)
beforeframes=c0(:,:,firstframebaseline:lastframebaseline);
[vertpixels horizpixels numbeforeframes]=size(beforeframes);
sumbefore=sum(beforeframes,3);
avebefore=sumbefore/numbeforeframes;
peakframes=c0(:,:,firstframepeak+10:lastframepeak+10);
[vertpixels horizpixels numpeakframes]=size(peakframes);
sumpeak=sum(peakframes,3);
avepeak=sumpeak/numpeakframes;
deltafc0=avepeak-avebefore;
deltafoverfc0=deltafc0./avebefore;

% analyze active run (c1)
beforeframes=c1(:,:,firstframebaseline:lastframebaseline);
sumbefore=sum(beforeframes,3);
avebefore=sumbefore/numbeforeframes;
peakframes=c1(:,:,firstframepeak+10:lastframepeak+10);
sumpeak=sum(peakframes,3);
avepeak=sumpeak/numpeakframes;
deltafc1=avepeak-avebefore;
deltafoverfc1=deltafc1./avebefore;

% take difference of active and blank run
diffdeltafoverf=deltafoverfc1-deltafoverfc0;

% combine the different blocks and show average image
map2(:,:,block)=diffdeltafoverf;
meanmap2=mean(map2,3);
%imagesc(meanmap);

%%%%%%%%%%%%%%%%%%%%%
%     3rd second    %
%%%%%%%%%%%%%%%%%%%%%
% analyze blank run (c0)
beforeframes=c0(:,:,firstframebaseline:lastframebaseline);
[vertpixels horizpixels numbeforeframes]=size(beforeframes);
sumbefore=sum(beforeframes,3);
avebefore=sumbefore/numbeforeframes;
peakframes=c0(:,:,firstframepeak+20:lastframepeak+20);
[vertpixels horizpixels numpeakframes]=size(peakframes);
sumpeak=sum(peakframes,3);
avepeak=sumpeak/numpeakframes;
deltafc0=avepeak-avebefore;
deltafoverfc0=deltafc0./avebefore;

% analyze active run (c1)
beforeframes=c1(:,:,firstframebaseline:lastframebaseline);
sumbefore=sum(beforeframes,3);
avebefore=sumbefore/numbeforeframes;
peakframes=c1(:,:,firstframepeak+20:lastframepeak+20);
sumpeak=sum(peakframes,3);
avepeak=sumpeak/numpeakframes;
deltafc1=avepeak-avebefore;
deltafoverfc1=deltafc1./avebefore;

% take difference of active and blank run
diffdeltafoverf=deltafoverfc1-deltafoverfc0;

% combine the different blocks and show average image
map3(:,:,block)=diffdeltafoverf;
meanmap3=mean(map3,3);

%%%%%%%%%%%%%%%%%%%%%
%     4th second    %
%%%%%%%%%%%%%%%%%%%%%
% analyze blank run (c0)
beforeframes=c0(:,:,firstframebaseline:lastframebaseline);
[vertpixels horizpixels numbeforeframes]=size(beforeframes);
sumbefore=sum(beforeframes,3);
avebefore=sumbefore/numbeforeframes;
peakframes=c0(:,:,firstframepeak+30:lastframepeak+30);
[vertpixels horizpixels numpeakframes]=size(peakframes);
sumpeak=sum(peakframes,3);
avepeak=sumpeak/numpeakframes;
deltafc0=avepeak-avebefore;
deltafoverfc0=deltafc0./avebefore;

% analyze active run (c1)
beforeframes=c1(:,:,firstframebaseline:lastframebaseline);
sumbefore=sum(beforeframes,3);
avebefore=sumbefore/numbeforeframes;
peakframes=c1(:,:,firstframepeak+30:lastframepeak+30);
sumpeak=sum(peakframes,3);
avepeak=sumpeak/numpeakframes;
deltafc1=avepeak-avebefore;
deltafoverfc1=deltafc1./avebefore;

% take difference of active and blank run
diffdeltafoverf=deltafoverfc1-deltafoverfc0;

% combine the different blocks and show average image
map4(:,:,block)=diffdeltafoverf;
meanmap4=mean(map4,3);

%%%%%%%%%%%%%%%%%%%%%
%     5th second    %
%%%%%%%%%%%%%%%%%%%%%
% analyze blank run (c0)
beforeframes=c0(:,:,firstframebaseline:lastframebaseline);
[vertpixels horizpixels numbeforeframes]=size(beforeframes);
sumbefore=sum(beforeframes,3);
avebefore=sumbefore/numbeforeframes;
peakframes=c0(:,:,firstframepeak+40:lastframepeak+40);
[vertpixels horizpixels numpeakframes]=size(peakframes);
sumpeak=sum(peakframes,3);
avepeak=sumpeak/numpeakframes;
deltafc0=avepeak-avebefore;
deltafoverfc0=deltafc0./avebefore;

% analyze active run (c1)
beforeframes=c1(:,:,firstframebaseline:lastframebaseline);
sumbefore=sum(beforeframes,3);
avebefore=sumbefore/numbeforeframes;
peakframes=c1(:,:,firstframepeak+40:lastframepeak+40);
sumpeak=sum(peakframes,3);
avepeak=sumpeak/numpeakframes;
deltafc1=avepeak-avebefore;
deltafoverfc1=deltafc1./avebefore;

% take difference of active and blank run
diffdeltafoverf=deltafoverfc1-deltafoverfc0;

% combine the different blocks and show average image
map5(:,:,block)=diffdeltafoverf;
meanmap5=mean(map5,3);
end

multiplier=10000;
subplot(2,3,1)
image(meanmap0*multiplier)
subplot(2,3,2)
image(meanmap1*multiplier)
subplot(2,3,3)
image(meanmap2*multiplier)
subplot(2,3,4)
image(meanmap3*multiplier)
subplot(2,3,5)
image(meanmap4*multiplier)
subplot(2,3,6)
image(meanmap5*multiplier)

figure
multiplier=-10000;
subplot(2,3,1)
image(meanmap0*multiplier)
subplot(2,3,2)
image(meanmap1*multiplier)
subplot(2,3,3)
image(meanmap2*multiplier)
subplot(2,3,4)
image(meanmap3*multiplier)
subplot(2,3,5)
image(meanmap4*multiplier)
subplot(2,3,6)
image(meanmap5*multiplier)

figure
imagesc(meanmap1)


